 /* TermEmulation.h
 *
 * Private interface to the Terminal Emulation package for GW Ada
 *
 * Manuel A. Perez
 * 9/3/93
 */
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */



#pragma once

#include "TermEmulationIntf.h"

enum { stNONE, stESC, stCSI, stNUM1, stSEMI, stNUM2 };

// constants for the font settings
enum { ftNormal=0, ftUnderline=2, ftBlinking=4, ftReverse=8 };

typedef struct {
	char	ch;
	short	col, row;
} Parms;

typedef Boolean (*CharCmp)(char ch);
typedef void (*ActionRtn)(Parms *p);

typedef struct {
	short		state;
	char		chcmp[25];	// 25 is an arbitrary number
	short		gotoState;
	ActionRtn	action;
} State;


/* Internal Routines */
#define chANY NULL
#define	doNothing NULL
static	void	doESC(Parms *p);
static	void	doDraw(Parms *p);
static	void	doNUM1(Parms *p);
static	void	doNUM2(Parms *p);
static	void	doClear(Parms *p);
static	void	doMove(Parms *p);
static	void	doVideo(Parms *p);
static	void	doSingleChar(Parms *p);

static	void	cursorUpdate(void);
static	void	cursorOff(void);
static	void	cursorOn(void);
static	void	cursorBlink(void);

static	Boolean	DoKeys(EventRecord *theEvent);
static	void	KeyTypedIn(char ch);

static	void	scrValidate(void);
static	void	scrSetCursor(void);
static	void	scrSetFace(void);
static	void	scrDrawText(char *str, short offset,
						short len, short style);
static	void	scrDrawChar(char ch, short style);
static	void	scrEraseFromTo(short fromCol, short fromRow, 
								short toCol, short toRow);

static	void	scrRectFromTo(Rect *r, short fromCol, short fromRow, 
								short toCol, short toRow);
static	void	scrCharToRect(short c, short r, Rect *rect);

static	void	scrNextRow(void);
static	void	scrNextCol(void);
static	void	scrPrevRow(void);
static	void	scrPrevCol(void);

static	void	scrScrollScreen(short i);
